// script.js

// Smooth scrolling for navigation links
document.querySelectorAll('header nav a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const targetId = this.getAttribute('href').substring(1);
        const targetSection = document.getElementById(targetId);
        if (targetSection) {
            targetSection.scrollIntoView({
                behavior: 'smooth'
            });
        }
    });
});

// Hero Slider functionality (kode yang tidak berubah)
let currentSlide = 0;
const slides = document.querySelectorAll('.slide');
const dots = document.querySelectorAll('.dot');
const totalSlides = slides.length;

function showSlide(index) {
    slides.forEach(slide => slide.classList.remove('active'));
    dots.forEach(dot => dot.classList.remove('active'));
    if (slides[index]) {
        slides[index].classList.add('active');
    }
    if (dots[index]) {
        dots[index].classList.add('active');
    }
}

function nextSlide() {
    currentSlide = (currentSlide + 1) % totalSlides;
    showSlide(currentSlide);
}

function prevSlide() {
    currentSlide = (currentSlide - 1 + totalSlides) % totalSlides;
    showSlide(currentSlide);
}

function goToSlide(index) {
    currentSlide = index;
    showSlide(currentSlide);
}

const prevHeroBtn = document.getElementById('prev-slide');
const nextHeroBtn = document.getElementById('next-slide');

if (prevHeroBtn) {
    prevHeroBtn.addEventListener('click', prevSlide);
}

if (nextHeroBtn) {
    nextHeroBtn.addEventListener('click', nextSlide);
}

dots.forEach((dot, index) => {
    dot.addEventListener('click', () => goToSlide(index));
});

let autoSlideInterval = setInterval(nextSlide, 5000);

const heroSection = document.querySelector('.hero-section');
if (heroSection) {
    heroSection.addEventListener('mouseenter', () => {
        clearInterval(autoSlideInterval);
    });

    heroSection.addEventListener('mouseleave', () => {
        autoSlideInterval = setInterval(nextSlide, 5000);
    });
}

if (slides.length > 0) {
    showSlide(currentSlide);
}

// Animation on scroll (kode yang tidak berubah)
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.classList.add('animate');
        }
    });
}, observerOptions);

document.querySelectorAll('section').forEach(section => {
    observer.observe(section);
});

// Button hover effects (kode yang tidak berubah)
document.querySelectorAll('.btn-book-now, .btn-promo, .btn-send').forEach(button => {
    button.addEventListener('mouseenter', function() {
        this.style.transform = 'scale(1.05)';
    });
    button.addEventListener('mouseleave', function() {
        this.style.transform = 'scale(1)';
    });
});

// Form validation and submission for booking form
const bookingForm = document.querySelector('#kontak form');
if (bookingForm) {
    bookingForm.addEventListener('submit', function(e) {
        e.preventDefault();
        const inputs = this.querySelectorAll('input, textarea');
        const select = this.querySelector('select');
        let isValid = true;
        inputs.forEach(input => {
            if (!input.value.trim()) {
                input.style.border = '2px solid red';
                isValid = false;
            } else {
                input.style.border = '2px solid #e0e0e0';
            }
        });
        if (!select.value) {
            select.style.border = '2px solid red';
            isValid = false;
        } else {
            select.style.border = '2px solid #e0e0e0';
        }
        if (isValid) {
            const formData = {
                nama: this.querySelector('[name="nama"]').value,
                acara: this.querySelector('[name="acara"]').value,
                whatsapp: this.querySelector('[name="whatsapp"]').value,
                pax: this.querySelector('[name="pax"]').value,
                date: this.querySelector('[name="date"]').value,
                email: this.querySelector('[name="email"]').value,
                venue: this.querySelector('[name="venue"]').value,
                package: this.querySelector('[name="package"]').value,
                requests: this.querySelector('[name="requests"]').value,
                timestamp: new Date().toISOString()
            };

            // Tampilkan modal hasil booking
            showBookingResult(formData);

            // Buka WhatsApp setelah modal ditampilkan
            const message = `Halo Partner Organizer, saya ingin booking wedding organizer.\n\nDetail Booking:\n- Nama Calon Pengantin: ${formData.nama}\n- Acara: ${formData.acara}\n- WhatsApp: ${formData.whatsapp}\n- Jumlah Tamu: ${formData.pax}\n- Tanggal: ${formData.date}\n- Email: ${formData.email}\n- Venue: ${formData.venue}\n- Package: ${formData.package}\n- Permintaan Tambahan: ${formData.requests || 'Tidak ada'}\n- Waktu Booking: ${new Date(formData.timestamp).toLocaleString()}\n\nMohon konfirmasi segera. Terima kasih!`;
            const encodedMessage = encodeURIComponent(message);
            const whatsappURL = `https://wa.me/6285791995465?text=${encodedMessage}`;

            // Untuk mobile, gunakan redirect agar WhatsApp terbuka dengan baik
            const isMobile = /Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
            console.log('Device detected:', isMobile ? 'Mobile' : 'Desktop');
            console.log('WhatsApp URL:', whatsappURL);

            if (isMobile) {
                console.log('Using mobile redirect');
                window.location.href = whatsappURL;
            } else {
                console.log('Using desktop popup');
                window.open(whatsappURL, '_blank');
            }

            this.reset();
        } else {
            alert('Please fill in all fields.');
        }
    });
}

// Function to show booking result modal (kode yang tidak berubah)
function showBookingResult(data) {
    const modal = document.createElement('div');
    modal.innerHTML = `
        <div style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); display: flex; justify-content: center; align-items: center; z-index: 10000;">
            <div style="background: white; padding: 40px; border-radius: 20px; text-align: center; max-width: 600px; width: 90%; box-shadow: 0 20px 40px rgba(0,0,0,0.2);">
                <h2 style="color: #333; margin-bottom: 20px;">Booking Berhasil!</h2>
                <div style="text-align: left; margin-bottom: 20px;">
                    <h3 style="color: #667eea;">Detail Booking:</h3>
                    <p><strong>Nama:</strong> ${data.nama}</p>
                    <p><strong>Acara:</strong> ${data.acara}</p>
                    <p><strong>WhatsApp:</strong> ${data.whatsapp}</p>
                    <p><strong>Jumlah Tamu:</strong> ${data.pax}</p>
                    <p><strong>Tanggal:</strong> ${data.date}</p>
                    <p><strong>Email:</strong> ${data.email}</p>
                    <p><strong>Venue:</strong> ${data.venue}</p>
                    <p><strong>Package:</strong> ${data.package}</p>
                    <p><strong>Permintaan Tambahan:</strong> ${data.requests || 'Tidak ada'}</p>
                    <p><strong>Waktu Booking:</strong> ${new Date(data.timestamp).toLocaleString()}</p>
                </div>
                <p style="color: #666; margin-bottom: 20px;">Terima kasih telah mempercayakan acara spesial Anda kepada kami. Kami akan segera menghubungi Anda untuk konfirmasi lebih lanjut.</p>
                <button id="close-result" style="padding: 10px 20px; background: #667eea; color: white; border: none; border-radius: 10px; cursor: pointer;">Tutup</button>
            </div>
        </div>
    `;
    document.body.appendChild(modal);

    document.getElementById('close-result').addEventListener('click', function() {
        document.body.removeChild(modal);
    });
}

// Typing effect, Parallax effect, Scroll to booking form (kode yang tidak berubah)
const heroText = document.querySelector('.text-overlay h1');
if (heroText) {
    const text = heroText.textContent || ''; 
    heroText.textContent = '';
    let i = 0;
    const typeWriter = () => {
        if (i < text.length) {
            heroText.textContent += text.charAt(i);
            i++;
            setTimeout(typeWriter, 100);
        }
    };
    if (text) {
        typeWriter();
    }
}

window.addEventListener('scroll', function() {
    const hero = document.querySelector('.hero-content');
    if (hero) {
        const scrollPosition = window.pageYOffset;
        hero.style.backgroundPositionY = scrollPosition * 0.5 + 'px';
    }
});

const bookButtons = document.querySelectorAll('.btn-book-now');
bookButtons.forEach(button => {
    button.addEventListener('click', function() {
        const targetSection = document.getElementById('kontak');
        if (targetSection) {
            targetSection.scrollIntoView({
                behavior: 'smooth'
            });
        }
    });
});

// Mobile menu functionality
const mobileMenuBtn = document.getElementById('mobile-menu-btn');
const mobileMenu = document.getElementById('mobile-menu');

if (mobileMenuBtn && mobileMenu) {
    mobileMenuBtn.addEventListener('click', function() {
        mobileMenu.classList.toggle('hidden');
    });
}

// Promo Modal functionality (kode yang tidak berubah)
const promoModal = document.getElementById('promo-modal');
const cekPromoBtn = document.getElementById('cek-promo-btn');
const closePromoBtn = document.querySelector('.close');

if (cekPromoBtn && promoModal && closePromoBtn) {
    cekPromoBtn.addEventListener('click', function() {
        promoModal.style.display = 'flex';
    });

    closePromoBtn.addEventListener('click', function() {
        promoModal.style.display = 'none';
    });

    window.addEventListener('click', function(event) {
        if (event.target == promoModal) {
            promoModal.style.display = 'none';
        }
    });
}

// Package details functionality (kode yang tidak berubah)
const packageSelect = document.getElementById('package-select');
const packageDetails = document.getElementById('package-details');
const packageContent = document.getElementById('package-content');

const packageData = {
    // ... (Data package Anda di sini)
};

function updatePackageDetails() {
    const selectedPackage = packageSelect.value;
    if (selectedPackage && packageData[selectedPackage]) {
        const details = packageData[selectedPackage];
        // Memastikan packageContent ada sebelum memanipulasinya
        if (packageContent) {
            packageContent.innerHTML = `<ul>${details.map(item => `<li>${item}</li>`).join('')}</ul>`;
        }
        if (packageDetails) {
            packageDetails.style.display = 'block';
        }
    } else {
        if (packageDetails) {
            packageDetails.style.display = 'none';
        }
    }
}

if (packageSelect) {
    packageSelect.addEventListener('change', updatePackageDetails);
    updatePackageDetails();
}

// Back to top button (kode yang tidak berubah)
const backToTopBtn = document.createElement('button');
backToTopBtn.id = 'back-to-top';
backToTopBtn.innerHTML = '↑';
document.body.appendChild(backToTopBtn);

window.addEventListener('scroll', function() {
    if (window.pageYOffset > 300) {
        backToTopBtn.style.display = 'block';
    } else {
        backToTopBtn.style.display = 'none';
    }
});

backToTopBtn.addEventListener('click', function() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
});

// Testimonial Management Class - DIUBAH UNTUK MENGAKTIFKAN GESER 5 KARTU
class TestimonialManager {
    
    constructor() {
        this.currentPosition = 0; 
        this.cardsPerView = 3;    // Jumlah kartu yang terlihat di desktop
        this.cardsToScroll = 1;   // Jumlah kartu yang digeser per klik
        this.gap = 30;            // Jarak antar kartu (sesuai CSS)
        this.init();
    }

    init() {
        // Kita tidak perlu memuat ulang dari JS, cukup inisialisasi fungsionalitasnya
        this.setupCarouselListeners();
        // Memastikan updateCarousel dipanggil saat DOM sudah dimuat 
        // agar pengukuran lebar kartu benar
        window.addEventListener('load', () => this.updateCarousel()); 
        this.updateCarousel(); // Dipanggil segera (mungkin 0 width)
    }
    
    // FUNGSI INTI UNTUK MENGGESER KONTEN CAROUSEL
    updateCarousel() {
        const track = document.querySelector('#carousel-track');
        // Seleksi hanya kartu di dalam track testimoni
        const cards = Array.from(document.querySelectorAll('#testimonials .testimonial-card'));
        const prevButton = document.getElementById('prevBtn');
        const nextButton = document.getElementById('nextBtn');

        if (!track || cards.length === 0 || !prevButton || !nextButton) return;

        // Hitung batas maksimum geser (Total Kartu - Kartu yang Terlihat)
        // Dengan 5 kartu, maxPosition = 5 - 3 = 2
        const maxPosition = cards.length - this.cardsPerView;
        
        // Lebar kartu pertama (termasuk margin/gap)
        const cardWidth = cards[0].offsetWidth; 
        const scrollUnit = cardWidth + this.gap; 
        
        const scrollDistance = scrollUnit * this.currentPosition;

        // Terapkan translasi untuk menggeser track
        track.style.transform = 'translateX(' + (-scrollDistance) + 'px)';

        // Logika Batas Akhir
        this.isPrevDisabled = this.currentPosition <= 0;
        this.isNextDisabled = this.currentPosition >= maxPosition;

        prevButton.disabled = this.isPrevDisabled;
        nextButton.disabled = this.isNextDisabled;

        prevButton.style.opacity = this.isPrevDisabled ? '0.5' : '1';
        nextButton.style.opacity = this.isNextDisabled ? '0.5' : '1'; 

        // Untuk memastikan logika tetap berjalan saat resize
        // console.log(`Posisi: ${this.currentPosition}, Max Posisi: ${maxPosition}`);
    }

    nextTestimonial() {
        const cards = document.querySelectorAll('#testimonials .testimonial-card');
        const maxPosition = cards.length - this.cardsPerView;
        
        if (this.currentPosition < maxPosition) {
            this.currentPosition += this.cardsToScroll;
            
            if (this.currentPosition > maxPosition) {
                this.currentPosition = maxPosition;
            }
            this.updateCarousel();
        }
    }

    prevTestimonial() {
        if (this.currentPosition > 0) {
            this.currentPosition -= this.cardsToScroll;
            
            if (this.currentPosition < 0) {
                this.currentPosition = 0;
            }
            this.updateCarousel();
        }
    }
    
    setupCarouselListeners() {
        const prevButton = document.getElementById('prevBtn');
        const nextButton = document.getElementById('nextBtn');

        if (prevButton) {
            prevButton.addEventListener('click', () => this.prevTestimonial());
        }

        if (nextButton) {
            nextButton.addEventListener('click', () => this.nextTestimonial());
        }

        // Panggil updateCarousel saat resize untuk menyesuaikan pengukuran lebar kartu
        window.addEventListener('resize', () => this.updateCarousel());
    }
    
    // Fungsi dummy agar class bisa diinisialisasi tanpa error dari kode Anda sebelumnya
    saveTestimonials() { /* ... */ }
    addTestimonial(name, text) { /* ... */ }
    setupAddTestimonialListeners() { /* ... */ }
}

// Inisialisasi Testimonial Manager saat DOM sudah dimuat
document.addEventListener('DOMContentLoaded', () => {
    new TestimonialManager();
});